const Overlay = require('./discord_overlay2.node');
const {ipcRenderer} = require('electron');
const {URL} = require('url');
const {OFFSCREEN_CLICK_ZONE_EVENT} = require('./events');

const sessionUrl = new URL(window.location);
const pid = sessionUrl.searchParams.get('pid');

Overlay.initializeOverlayContext(parseInt(pid, 10));

let clickZoneCallback;

ipcRenderer.on(OFFSCREEN_CLICK_ZONE_EVENT, (event, name) => {
  if (clickZoneCallback) {
    clickZoneCallback(name);
  }
});

module.exports = {};
module.exports.sendCommand = Overlay.sendCommandFromOverlay;
module.exports.setClickZoneCallback = callback => {
  clickZoneCallback = callback;
};
