let VoiceEngine = require('./discord_voice.node')
let ChildProcess = require('child_process');

let appSettings = global.appSettings;
let useLegacyAudioDevice = appSettings ? appSettings.get('useLegacyAudioDevice') : false;

global.features.declareSupported('voice_sound_stop_loop');

let _playSound = VoiceEngine.playSound;

VoiceEngine.createTransport = VoiceEngine._createTransport;
VoiceEngine.setUseLegacyAudioDevice = function (useLegacyAudioDevice_) {
  if (!appSettings) {
    console.warn('Unable to access app settings.');
    return;
  }

  if (useLegacyAudioDevice === useLegacyAudioDevice_) {
    return;
  }

  appSettings.set('useLegacyAudioDevice', useLegacyAudioDevice_);
  appSettings.save();
  ChildProcess.spawn(process.argv[0], process.argv.splice(1), { detached: true });
  process.exit(0);
}
VoiceEngine.getUseLegacyAudioDevice = function () {
  return useLegacyAudioDevice;
}
VoiceEngine.playSound = function() {
  if (arguments.length === 2) {
    _playSound(1, arguments[0], false, arguments[1]);
  }
  else if (arguments.length === 4) {
    _playSound(arguments[0], arguments[1], arguments[2], arguments[3]);
  }
}

console.log(`Initializing voice engine [legacy device: ${useLegacyAudioDevice}]`);
VoiceEngine.initialize({useLegacyAudioDevice})

module.exports = VoiceEngine;
