var overlay = require('./discord_overlay.node');
var BrowserWindow = require('browser-window');

var overlayWindow = null;

exports.generateSession = overlay.generateSession;
exports.getAnalyticsData = overlay.getAnalyticsData;
exports.setAttachCallback = overlay.setAttachCallback;
exports.attachToProcess = overlay.attachToProcess;
exports.detachFromProcess = overlay.detachFromProcess;
exports.setInputLocked = overlay.setInputLocked;

exports.despawnOverlay = function () {
  overlay.destroyOverlayWindow(() => {
    if (overlayWindow != null) {
      overlayWindow.close();
      overlayWindow = null;
    }
  });
}

exports.spawnOverlay = function _spawnOverlay(url) {
  overlay.createOverlayWindow(
    (width, height) => {
      if (overlayWindow == null) {
        overlayWindow = new BrowserWindow({
          width: width,
          height: height,
          resizable: false,
          frame: false,
          'auto-hide-menu-bar': true,
          'use-content-size': true,
          transparent: true
        });
        overlayWindow.webContents.on('crashed', () => {
          overlayWindow.destroy();
          overlayWindow = null;
          _spawnOverlay(url);
        });
        overlayWindow.on('closed', () => {
            overlayWindow = null;
        });
        overlayWindow.loadURL(url);
      }
      else {
        overlayWindow.setContentSize(width, height);
      }
    }
  );
}
