var overlay = require('./discord_overlay.node');
var BrowserWindow = require('browser-window');

var overlayWindow = null;

exports.attachToProcess = overlay.attachToProcess;
exports.detachFromProcess = overlay.detachFromProcess;

exports.despawnOverlay = function () {
  overlay.destroyOverlayWindow(() => {
    if (overlayWindow != null) {
      overlayWindow.destroy();
      overlayWindow = null;
    }
  });
}

exports.spawnOverlay = function (url) {
  overlay.createOverlayWindow(
    (width, height) => {
      if (overlayWindow == null) {
        overlayWindow = new BrowserWindow({
          width: width,
          height: height,
          resizable: false,
          frame: false,
          'auto-hide-menu-bar': true,
          'use-content-size': true,
          transparent: true
        });
        overlayWindow.webContents.on('crashed', () => {
          overlayWindow.loadUrl(url);
        });
        overlayWindow.loadUrl(url);
      }
      else {
        overlayWindow.setContentSize(width, height);
      }
    }
  );
}
