// Generated by CoffeeScript 1.7.1
(function() {
  var EventEmitter, app, bindings;

  EventEmitter = require('events').EventEmitter;

  bindings = process.atomBinding('app');

  app = bindings.app;

  app.__proto__ = EventEmitter.prototype;

  app.setApplicationMenu = function(menu) {
    return require('menu').setApplicationMenu(menu);
  };

  app.getApplicationMenu = function() {
    return require('menu').getApplicationMenu();
  };

  app.commandLine = {
    appendSwitch: bindings.appendSwitch,
    appendArgument: bindings.appendArgument
  };

  if (process.platform === 'darwin') {
    app.dock = {
      bounce: function(type) {
        if (type == null) {
          type = 'informational';
        }
        return bindings.dockBounce(type);
      },
      cancelBounce: bindings.dockCancelBounce,
      setBadge: bindings.dockSetBadgeText,
      getBadge: bindings.dockGetBadgeText,
      hide: bindings.dockHide,
      show: bindings.dockShow,
      setMenu: bindings.dockSetMenu
    };
  }

  app.once('ready', function() {
    return app.emit('finish-launching');
  });

  app.terminate = app.quit;

  app.exit = process.exit;

  app.getHomeDir = function() {
    return app.getPath('home');
  };

  app.getDataPath = function() {
    return app.getPath('userData');
  };

  app.setDataPath = function(path) {
    return app.setPath('userData', path);
  };

  module.exports = app;

}).call(this);
