// Generated by CoffeeScript 1.7.1
(function() {
  var attachGuest, createGuest, destroyGuest, embedderElementsMap, getNextInstanceId, guestInstances, ipc, nextInstanceId, reverseEmbedderElementsMap, supportedWebViewEvents, webContents, webViewManager,
    __slice = [].slice;

  ipc = require('ipc');

  webContents = require('web-contents');

  webViewManager = null;

  supportedWebViewEvents = ['did-finish-load', 'did-fail-load', 'did-frame-finish-load', 'did-start-loading', 'did-stop-loading', 'did-get-redirect-request', 'console-message', 'new-window', 'close', 'crashed', 'destroyed'];

  nextInstanceId = 0;

  guestInstances = {};

  embedderElementsMap = {};

  reverseEmbedderElementsMap = {};

  getNextInstanceId = function(webContents) {
    return ++nextInstanceId;
  };

  createGuest = function(embedder, params) {
    var destroy, destroyEvents, event, guest, id, _fn, _i, _j, _len, _len1;
    if (webViewManager == null) {
      webViewManager = process.atomBinding('web_view_manager');
    }
    id = getNextInstanceId(embedder);
    guest = webContents.create({
      isGuest: true,
      guestInstanceId: id,
      storagePartitionId: params.storagePartitionId
    });
    guestInstances[id] = {
      guest: guest,
      embedder: embedder
    };
    destroyEvents = ['destroyed', 'crashed', 'did-navigate-to-different-page'];
    destroy = function() {
      if (guestInstances[id] != null) {
        return destroyGuest(embedder, id);
      }
    };
    for (_i = 0, _len = destroyEvents.length; _i < _len; _i++) {
      event = destroyEvents[_i];
      embedder.once(event, destroy);
    }
    guest.once('destroyed', function() {
      var _j, _len1, _results;
      _results = [];
      for (_j = 0, _len1 = destroyEvents.length; _j < _len1; _j++) {
        event = destroyEvents[_j];
        _results.push(embedder.removeListener(event, destroy));
      }
      return _results;
    });
    guest.once('did-attach', function() {
      var max, min;
      params = this.attachParams;
      delete this.attachParams;
      this.viewInstanceId = params.instanceId;
      min = {
        width: params.minwidth,
        height: params.minheight
      };
      max = {
        width: params.maxwidth,
        height: params.maxheight
      };
      this.setAutoSize(params.autosize, min, max);
      if (params.src) {
        if (params.httpreferrer) {
          this.loadUrl(params.src, {
            httpreferrer: params.httpreferrer
          });
        } else {
          this.loadUrl(params.src);
        }
      }
      if (params.allowtransparency != null) {
        return this.setAllowTransparency(params.allowtransparency);
      }
    });
    _fn = function(event) {
      return guest.on(event, function() {
        var args, _;
        _ = arguments[0], args = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
        return embedder.send.apply(embedder, ["ATOM_SHELL_GUEST_VIEW_INTERNAL_DISPATCH_EVENT-" + guest.viewInstanceId, event].concat(__slice.call(args)));
      });
    };
    for (_j = 0, _len1 = supportedWebViewEvents.length; _j < _len1; _j++) {
      event = supportedWebViewEvents[_j];
      _fn(event);
    }
    guest.on('ipc-message-host', function(_, packed) {
      var args, channel;
      channel = packed[0], args = 2 <= packed.length ? __slice.call(packed, 1) : [];
      return embedder.send.apply(embedder, ["ATOM_SHELL_GUEST_VIEW_INTERNAL_IPC_MESSAGE-" + guest.viewInstanceId, channel].concat(__slice.call(args)));
    });
    guest.on('size-changed', function() {
      var args, _;
      _ = arguments[0], args = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
      return embedder.send.apply(embedder, ["ATOM_SHELL_GUEST_VIEW_INTERNAL_SIZE_CHANGED-" + guest.viewInstanceId].concat(__slice.call(args)));
    });
    return id;
  };

  attachGuest = function(embedder, elementInstanceId, guestInstanceId, params) {
    var guest, key, oldGuestInstanceId, _ref;
    guest = guestInstances[guestInstanceId].guest;
    key = "" + (embedder.getId()) + "-" + elementInstanceId;
    oldGuestInstanceId = embedderElementsMap[key];
    if (oldGuestInstanceId != null) {
      if (oldGuestInstanceId === guestInstanceId) {
        return;
      }
      if (guestInstances[oldGuestInstanceId] == null) {
        return;
      }
      destroyGuest(embedder, oldGuestInstanceId);
    }
    webViewManager.addGuest(guestInstanceId, elementInstanceId, embedder, guest, {
      nodeIntegration: params.nodeintegration,
      plugins: params.plugins,
      disableWebSecurity: params.disablewebsecurity,
      preloadUrl: (_ref = params.preload) != null ? _ref : ''
    });
    guest.attachParams = params;
    embedderElementsMap[key] = guestInstanceId;
    return reverseEmbedderElementsMap[guestInstanceId] = key;
  };

  destroyGuest = function(embedder, id) {
    var key;
    webViewManager.removeGuest(embedder, id);
    guestInstances[id].guest.destroy();
    delete guestInstances[id];
    key = reverseEmbedderElementsMap[id];
    if (key != null) {
      delete reverseEmbedderElementsMap[id];
      return delete embedderElementsMap[key];
    }
  };

  ipc.on('ATOM_SHELL_GUEST_VIEW_MANAGER_CREATE_GUEST', function(event, type, params, requestId) {
    return event.sender.send("ATOM_SHELL_RESPONSE_" + requestId, createGuest(event.sender, params));
  });

  ipc.on('ATOM_SHELL_GUEST_VIEW_MANAGER_ATTACH_GUEST', function(event, elementInstanceId, guestInstanceId, params) {
    return attachGuest(event.sender, elementInstanceId, guestInstanceId, params);
  });

  ipc.on('ATOM_SHELL_GUEST_VIEW_MANAGER_DESTROY_GUEST', function(event, id) {
    return destroyGuest(event.sender, id);
  });

  ipc.on('ATOM_SHELL_GUEST_VIEW_MANAGER_SET_AUTO_SIZE', function(event, id, params) {
    var _ref;
    return (_ref = guestInstances[id]) != null ? _ref.guest.setAutoSize(params.enableAutoSize, params.min, params.max) : void 0;
  });

  ipc.on('ATOM_SHELL_GUEST_VIEW_MANAGER_SET_ALLOW_TRANSPARENCY', function(event, id, allowtransparency) {
    var _ref;
    return (_ref = guestInstances[id]) != null ? _ref.guest.setAllowTransparency(allowtransparency) : void 0;
  });

  exports.getGuest = function(id) {
    var _ref;
    return (_ref = guestInstances[id]) != null ? _ref.guest : void 0;
  };

  exports.getEmbedder = function(id) {
    var _ref;
    return (_ref = guestInstances[id]) != null ? _ref.embedder : void 0;
  };

}).call(this);
