var EventEmitter = require('events').EventEmitter;
var util = require('util');
var SquirrelUpdate = require('./squirrel-update');

function AutoUpdater() {
  this.updateUrl = null;
  this.updateVersion = null;
}
util.inherits(AutoUpdater, EventEmitter);

AutoUpdater.prototype.setFeedUrl = function(updateUrl) {
  this.updateUrl = updateUrl;
};

AutoUpdater.prototype.quitAndInstall = function() {
  if (SquirrelUpdate.existsSync()) {
    var app = require('app');
    SquirrelUpdate.restart(app, this.updateVersion || app.getVersion());
  }
  else {
    require('auto-updater').quitAndInstall();
  }
};

AutoUpdater.prototype.downloadUpdate = function(callback) {
  SquirrelUpdate.spawn(['--download', this.updateUrl], function(error, stdout) {
    if (error != null) {
      return callback(error);
    }

    try {
      // Last line of the output is JSON detauls about the releases
      var json = stdout.trim().split('\n').pop();
      var update = JSON.parse(json).releasesToApply.pop();
      callback(null, update);
    }
    catch (error) {
      error.stdout = stdout;
      callback(error);
    }
  });
};

AutoUpdater.prototype.installUpdate = function(callback) {
  SquirrelUpdate.spawn(['--update', this.updateUrl], callback);
};

AutoUpdater.prototype.checkForUpdates = function() {
  if (this.updateUrl == null) {
    throw new Error('Update URL is not set');
  }

  this.emit('checking-for-update');

  if (!SquirrelUpdate.existsSync()) {
    this.emit('update-not-available');
    return;
  }

  this.downloadUpdate(function(error, update) {
    if (error != null) {
      this.emit('update-not-available');
      return;
    }

    if (update == null) {
      this.emit('update-not-available');
      return;
    }

    this.installUpdate(function(error) {
      if (error != null) {
        this.emit('update-not-available');
        return;
      }

      this.updateVersion = update.version;

      this.emit('update-available');
      this.emit('update-downloaded',
        {},
        update.release,
        update.version,
        new Date(),
        this.updateUrl,
        this.quitAndInstall.bind(this));
    }.bind(this));
  }.bind(this));
};

module.exports = new AutoUpdater();
